unit uRemetente;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type

  TUsuario = record
    Nome    : String[40];
    Senha   : String[20];
  end;
  PUSUARIO = ^TUsuario;

  TFrmRemetente = class(TForm)
    btnEnviar: TButton;
    edtUsuario: TEdit;
    lblUsuario: TLabel;
    lblSenha: TLabel;
    edtSenha: TEdit;
    procedure btnEnviarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmRemetente: TFrmRemetente;

implementation

{$R *.DFM}

procedure TFrmRemetente.btnEnviarClick(Sender: TObject);
var
  pDadosUsuario : PUSUARIO;
  lCopyData: TCopyDataStruct;
  hHandleReceptor: HWND;
begin
  // Localiza a janela receptora
  hHandleReceptor := FindWindowEx(0, 0, nil, PChar('Receptor'));
  if hHandleReceptor <> 0 then
  begin
    New(pDadosUsuario);
    pDadosUsuario^.Nome := edtUsuario.Text;
    pDadosUsuario^.Senha := edtSenha.Text;
    // Reservado para o seu prprio uso
    lCopyData.dwData := 0;
    // Nmero de bytes a ser transmitido
    lCopyData.cbData := sizeof(TUsuario);
    // Aponta para o primeiro a byte dos dados
    lCopyData.lpData := pDadosUsuario;
    // Envia a mensagem para a janela receptora
    SendMessage(hHandleReceptor, WM_COPYDATA, 0, INTEGER(@lCopyData));
    Dispose(pDadosUsuario);
  end
  else
    ShowMessage('Janela receptora no encontrada!');
end;

end.
